//
//  DGActivityIndicatorBallScaleAnimation.m
//  DGActivityIndicatorExample
//
//  Created by Nguyen Vinh on 7/20/15.
//  Copyright (c) 2015 Danil Gontovnik. All rights reserved.
//

#import "DGActivityIndicatorBallScaleAnimation.h"

@implementation DGActivityIndicatorBallScaleAnimation

- (void)setupAnimationInLayer:(CALayer *)layer withSize:(CGSize)size tintColor:(UIColor *)tintColor {
    CGFloat duration = 1.0f;
    
    // Scale animation
    CABasicAnimation *scaleAnimation = [self createBasicAnimationWithKeyPath:@"transform.scale"];
    
    scaleAnimation.duration = duration;
    scaleAnimation.fromValue = @0.0f;
    scaleAnimation.toValue = @1.0f;
    
    // Opacity animation
    CABasicAnimation *opacityAnimation = [self createBasicAnimationWithKeyPath:@"opacity"];
    
    opacityAnimation.duration = duration;
    opacityAnimation.fromValue = @1.0f;
    opacityAnimation.toValue = @0.0f;
    
    // Animation
    CAAnimationGroup *animation = [self createAnimationGroup];;
    
    animation.animations = @[scaleAnimation, opacityAnimation];
    animation.duration = duration;
    animation.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut];
    animation.repeatCount = HUGE_VALF;
    
    // Draw circle
    CAShapeLayer *circle = [CAShapeLayer layer];
    UIBezierPath *circlePath = [UIBezierPath bezierPathWithRoundedRect: CGRectMake(0, 0, size.width, size.height) cornerRadius:size.width / 2];
    
    circle.fillColor = tintColor.CGColor;
    circle.path = circlePath.CGPath;
    [circle addAnimation:animation forKey:@"animation"];
    circle.frame = CGRectMake((layer.bounds.size.width - size.width) / 2, (layer.bounds.size.height - size.height) / 2, size.width, size.height);
    [layer addSublayer:circle];
}

@end
